package ar;


import com.spire.barcode.BarCodeGenerator;
import com.spire.barcode.BarCodeType;
import com.spire.barcode.BarcodeSettings;
import com.spire.barcode.QRCodeECL;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * Hello world!
 *
 */
public class App {
    public static void main(String[] args) throws IOException {
        /* System.out.println("Hello World!"); */

        /* Desde aca QR */
        // Instanciamos el objeto BarcodeSettings - Instantiate a BarcodeSettings object
        BarcodeSettings settings = new BarcodeSettings();
        // Seleccionamos el tipo de codigo de barras. QR_Code - Set barcode type
        settings.setType(BarCodeType.QR_Code);
        // El dato / texto / URL para crear el QR - Set barcode data
        String data = "Que bien que sale esto!";         //Aca va el texto del QR
        settings.setData(data);
        // Establece el ancho - Set barcode module width
        settings.setX(2);
        // Nivel de correccion de error - Set error correction level
        settings.setQRCodeECL(QRCodeECL.M);

        // Texto superior - Set top text
        settings.setTopText("Marcelo Garassino");                   //Texto superior
        // Texto inferior - Set bottom text
        settings.setBottomText("QR Party");               //Texto inferior

        // Desde aca se ajusta lo que se ve y lo que no - Set text visibility
        settings.setShowText(false);
        settings.setShowTopText(true);
        settings.setShowBottomText(true);

        // Visibilidad del borde - Set border visibility
        settings.hasBorder(false);

        // Instantiate a BarCodeGenerator object based on the specific settings
        BarCodeGenerator barCodeGenerator = new BarCodeGenerator(settings);
        // Generate QR code image
        BufferedImage bufferedImage = barCodeGenerator.generateImage();
        //Guardo el QR en un archivo QR_Code.png para poder imprimirlo por ejemplo en una hoja de etiquetas, incorporarlo a un WORD etc. -  save the image to a .png file
        ImageIO.write(bufferedImage, "png", new File("QR_Code.png"));

    }
}
