package ar;

//procIdWin necesita estos import
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

//motherIdWin necesita estos imports


//PowerShellComandos
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;


/**
 * Hello world!
 *
 */
public class App 
{
    public static void main( String[] args ) throws IOException
    {
        System.out.println( "Hello World!" );
        obtenerOS();

        //Si es windows sigo comprobando
        if (OS.contains("win")){
            procIdWin();
        };

        //Otra comprobacion
        System.out.println(System.getenv("COMPUTERNAME")); //ASUS-MaG devuelve
        System.out.println(System.getenv("NUMBER_OF_PROCESSORS").toString()); //Devuelve lista de path y algunos datos de procesador y windows.
        //OS - COMPUTERNAME - PROCESSOR_REVISION - SystemRoot - HOMEDRIVE - NUMBER_OF_PROCESSORS

        System.out.println("--------------------------------------------------------");
        //Comprueba motherboard ID
        System.out.println("Motherboard ID");
        motherIdWin ();

        System.out.println("--------------------------------------------------------");
        //PowerShellComandos
        PowerShellCommando();
    }

    private static String OS = System.getProperty("os.name").toLowerCase();
 
    public static void obtenerOS() {
 
        System.out.println(OS);
 
        if (isWindows()) {
            System.out.println("This is Windows");
        } else if (isMac()) {
            System.out.println("This is MacOS");
        } else if (isUnix()) {
            System.out.println("This is Unix or Linux");
        } else if (isSolaris()) {
            System.out.println("This is Solaris");
        } else {
            System.out.println("Your OS is not supported!!");
        }
    }
 
    public static boolean isWindows() {
        return OS.contains("win");
    }
 
    public static boolean isMac() {
        return OS.contains("mac");
    }
 
    public static boolean isUnix() {
        return (OS.contains("nix") || OS.contains("nux") || OS.contains("aix"));
    }
 
    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static String getOS(){
        if (isWindows()) {
            return "win";
        } else if (isMac()) {
            return "osx";
        } else if (isUnix()) {
            return "uni";
        } else if (isSolaris()) {
            return "sol";
        } else {
            return "err";
        }
    }
/* ---------------------------------------------Si es windows Procesador ID------------------------------------------- */

    public static void procIdWin(){
        try {
            @SuppressWarnings("deprecation") 
            // el metodo .exec de la siguiente linea esta deprecado. para evitar la advertencia -> @SuppressWarnings("deprecation") 
            Process process = Runtime.getRuntime().exec("wmic cpu get ProcessorId");
            process.getOutputStream().close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line;
            while ((line = reader.readLine()) != null) {
               if (!line.trim().equals("")){
                  System.out.println(line.trim());
               }
            }
         } catch (IOException e) {
            e.printStackTrace();
         }
    }

    /* -----------------------------------------Motherboar datos--------------------------------------------------------- */
    public static void motherIdWin (){
        String result = "";
        try {
          File file = File.createTempFile("GetMBSerial",".vbs");
          file.deleteOnExit();
          FileWriter fw = new FileWriter(file);

          String vbs =
             "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\n"
            + "Set colItems = objWMIService.ExecQuery _ \n"
            + "   (\"Select * from Win32_ComputerSystemProduct\") \n"
            + "For Each objItem in colItems \n"
            + "    Wscript.Echo objItem.IdentifyingNumber \n"
            + "Next \n";

          fw.write(vbs);
          fw.close();
          @SuppressWarnings("deprecation")
          Process gWMI = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
          BufferedReader input = new BufferedReader(new InputStreamReader(gWMI.getInputStream()));
          String line;
          while ((line = input.readLine()) != null) {
             result += line;
             System.out.println(line);
          }
          input.close();
        }
        catch(Exception e){
            e.printStackTrace();
        }
        result = result.trim();
        //return result;
      }

      //A traves de powershell se pueden obtener datos del motherboar con el siguiente comando:
      //    Get-CimInstance -Class Win32_BaseBoard | Format-Table Manufacturer, Product, SerialNumber, Version -Auto

      //A traves de powershell se pueden obtener datos de la memoria con el siguietn comando:
      //    Get-CimInstance Win32_PhysicalMemory | ft Manufacturer, Capacity, SerialNumber, BankLabel, ConfiguredClockSpeed, DeviceLocator -Auto

      //A traves de powershell se pueden obtener datos del procesador
      //    Get-CimInstance Win32_Processor
      //    Get-WmiObject -Class Win32_Processor | Select-Object -Property [a-z]*


      /* -------------------------------------------------Ejecutar powershell------------------------------------------- */
      /* Permite desdeel powershell obtener datos del hardware */

    public static void PowerShellCommando() throws IOException {
       
         //String command = "powershell.exe  your command";
         //Getting the version
         /* String command = "powershell.exe  $PSVersionTable.PSVersion"; */
         String command = "powershell.exe Get-WmiObject -Class Win32_Processor | Select-Object -Property [a-z]*";
         // Executing the command
         @SuppressWarnings("deprecation")
        Process powerShellProcess = Runtime.getRuntime().exec(command);
         // Getting the results
         powerShellProcess.getOutputStream().close();
         String line;
         System.out.println("Standard Output:");
         BufferedReader stdout = new BufferedReader(new InputStreamReader(
           powerShellProcess.getInputStream()));
         while ((line = stdout.readLine()) != null) {
          System.out.println(line);
         }
         stdout.close();
         System.out.println("Standard Error:");
         BufferedReader stderr = new BufferedReader(new InputStreamReader(
           powerShellProcess.getErrorStream()));
         while ((line = stderr.readLine()) != null) {
          System.out.println(line);
         }
         stderr.close();
         System.out.println("Done");
       
        }
       
       




}



