package ar;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.JOptionPane;

import org.json.JSONObject;

import com.fasterxml.jackson.databind.ObjectMapper;  //JSON ejemplo del profe
import java.sql.Statement;

import java.sql.Timestamp;  //Lo uso para los campos de fecha que son tipo date time
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;


public class sql {

/* -------------------------------------ZONA DE TEST------------------------------------------------------ */
    public static void  prueba() {
        Connection con;
        con = conectar();
        desconectar(con);

    }





/* ----------------------------------------------------------------------------------------------------------------------
     * Desde aca metodos de conexion 
     */

    // Establece la conexion con la DB
    public static Connection conectar() {

        
        Connection con = null;
        String base = "nora"; // Nombre de la base de datos
        String url = "jdbc:mysql://gara.ddns.net:3306/" + base; // Direccion, puerto y nombre de la Base de Datos
        String user = "Nora"; // Usuario de Acceso a MySQL
        String password = "noadhe77"; // Password del usuario


        try {            
            Class.forName("com.mysql.cj.jdbc.Driver");
            con = DriverManager.getConnection(url, user, password);
            System.out.println("Conexion Exitosa");
        } catch (ClassNotFoundException | SQLException e) {
            System.err.println(e);
        }
        return con;
    }

    public static void desconectar(Connection conexion) {
        try{
            conexion.close();
            System.out.println("Desconexion Exitosa");
        }catch(Exception e) {
            System.err.println(e);
        }
    }



/* -------------------------------------Agregar Registro------------------------------------------------------ */
public static void agregarProducto(
    
    Integer id,
    String producto,
    String codigo,
    String descripcion,
    Double costo,
    Timestamp fechacosto,
    Double precvta,
    Timestamp fechaprecvta,
    String proveedor,
    Integer ptoderepos
) {
    Connection con;

    try {
        con = conectar();
        PreparedStatement ps = con.prepareStatement("INSERT INTO productos (Producto, Codigo, Descripcion, Costo, FechCost, PrecVta, FechaPrecVta, Proveedor, PtoDeRepos) VALUES(?,?,?,?,?,?,?,?,?) ",
        Statement.RETURN_GENERATED_KEYS);

        ps.setString(1, producto);
        ps.setString(2, codigo);
        ps.setString(3, descripcion);
        ps.setDouble(4, costo);
        ps.setTimestamp(5, fechacosto);
        ps.setDouble(6, precvta);
        ps.setTimestamp(7, fechaprecvta);
        ps.setString(8, proveedor);
        ps.setInt(9, ptoderepos);

        int res = ps.executeUpdate();

        if (res > 0) { 
           /*  // Se obtiene el ID del usuario registrado
            ResultSet generatedKeys = ps.getGeneratedKeys();
            int usrid=-1;
            if (generatedKeys.next()) {
                usrid = generatedKeys.getInt(1);
            }

            if (admin) {
                PreparedStatement ps3 = con.prepareStatement("INSERT INTO administradores (usrid, esadmin) VALUES (?,?)");
                ps3.setInt(1, usrid);
                ps3.setBoolean(2, admin); // admin es el valor booleano

                ps3.executeUpdate();
            } */
        }
        desconectar(con);
    } catch (SQLException e) {
        System.err.println(e);
    }
}


//-------------------------------------Leer/Buscar multiples Registros ------------------------------------------------------
    // para llenar el ArrayList con objetos de clase usuario, creo los atributos en usuario.javacon sus getters y setters
    public static String buscarProductoPorPatron(String patron) {
        Connection con;
        ResultSet rs = null;
        
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<producto> lista = new ArrayList<>();
        producto prod;

        try {
            con = conectar();
            
            PreparedStatement ps = con.prepareStatement("(SELECT productos.id, productos.producto, productos.codigo, productos.descripcion," +
		            " productos.costo, productos.fechcost, productos.precvta, productos.fechaprecvta, productos.proveedor, productos.ptoderepos  " +
                    "FROM productos " +
                    "" +
                    "WHERE (producto LIKE ?) OR (codigo LIKE ?) OR (descripcion LIKE ?)  OR (proveedor LIKE ?) " +
                    "ORDER BY productos.id);");
            ps.setString(1, "%"+patron+"%");
            ps.setString(2, "%"+patron+"%");
            ps.setString(3, "%"+patron+"%");
            ps.setString(4, "%"+patron+"%");
            rs = ps.executeQuery();

            

            // Leo uno a uno los registros traidos del la DB y los cargo en la lista
            while (rs.next()) {
                prod = new producto();
                prod.setId(rs.getInt("id"));
                prod.setProducto(rs.getString("producto"));
                prod.setCodigo(rs.getString("codigo"));
                prod.setDescripcion(rs.getString("descripcion"));
                prod.setCosto(rs.getDouble("costo"));
                prod.setFechacosto(rs.getTimestamp("fechcost"));
                prod.setPrecvta(rs.getDouble("precvta"));
                prod.setFechaprecvta(rs.getTimestamp("fechaprecvta"));
                prod.setProveedor(rs.getString("proveedor"));
                prod.setPtoderepos(rs.getInt("ptoderepos"));

                lista.add(prod);
            }
            desconectar(con); //Desconecto de la DB

        } catch (SQLException e) {
            System.err.println(e);
        }
        
        if (lista.size() == 0){
            return "La busqueda arrojo cero resultados";
        };

        //Crea el json
        String usrJSON;
        try {
            usrJSON = mapper.writeValueAsString(lista);
            System.out.println(usrJSON);


            //Extra para probar el reformateo de fecha - Tambien se prueba convertir un String en JSON para poder buscar parametros por su nombre
            String usr1JSON = usrJSON;
            JSONObject jsonObject = new JSONObject(usr1JSON.replace("[", "").replace("]","")); //convierto el string usrJSON en un objeto json para buscar la fecha
            System.out.println(jsonObject.getString("fechacosto"));
           
            Long mili=Long.parseLong(jsonObject.getString("fechacosto")) ; //convierto la fecha en Long
            Instant instant = Instant.ofEpochMilli(mili );
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("-03:00")); //Buenos Aires zona horaria - otro ej "UTC"
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedDateTime = localDateTime.format(formatter);
            System.out.println(formattedDateTime);
            //Hasta ACA la prueba de la fecha/hora - Tambien el JSON

            return usrJSON;
        } catch (Exception ex) {
            Logger.getLogger(sql.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "Ocurrio un error al crear json, la busqueda pudo haber arrojado null";
    }


    //-------------------------------------Leer/Buscar Registros por id------------------------------------------------------
    // para llenar el ArrayList con objetos de clase usuario, creo los atributos en usuario.javacon sus getters y setters
    public static String buscarProductoPorid(Integer patron) {

        System.out.println("buscarProductoPorid: "+patron);
        Connection con;
        ResultSet rs = null;
        
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<producto> lista = new ArrayList<>();
        producto prod;

        try {
            con = conectar();
            
            PreparedStatement ps = con.prepareStatement("SELECT productos.id, productos.producto, productos.codigo, productos.descripcion," +
		            " productos.costo, productos.fechcost, productos.precvta, productos.fechaprecvta, productos.proveedor, productos.ptoderepos  " +
                    "FROM productos " +
                    "" +
                    "WHERE id = ? ; "
                    );
            ps.setInt(1, patron);
            rs = ps.executeQuery();

            

            // Leo uno a uno los registros traidos del la DB y los cargo en la lista
            while (rs.next()) {
                prod = new producto();
                prod.setId(rs.getInt("id"));
                prod.setProducto(rs.getString("producto"));
                prod.setCodigo(rs.getString("codigo"));
                prod.setDescripcion(rs.getString("descripcion"));
                prod.setCosto(rs.getDouble("costo"));
                prod.setFechacosto(rs.getTimestamp("fechcost"));
                prod.setPrecvta(rs.getDouble("precvta"));
                prod.setFechaprecvta(rs.getTimestamp("fechaprecvta"));
                prod.setProveedor(rs.getString("proveedor"));
                prod.setPtoderepos(rs.getInt("ptoderepos"));

                lista.add(prod);
            }
            desconectar(con); //Desconecto de la DB

        } catch (SQLException e) {
            System.err.println(e);
        }
        
        if (lista.size() == 0){
            return "La busqueda arrojo cero resultados";
        };

        //Crea el json
        String usrJSON;
        try {
            usrJSON = mapper.writeValueAsString(lista);
            System.out.println(usrJSON);


            //Extra para probar el reformateo de fecha - Tambien se prueba convertir un String en JSON para poder buscar parametros por su nombre
            String usr1JSON = usrJSON;
            JSONObject jsonObject = new JSONObject(usr1JSON.replace("[", "").replace("]","")); //convierto el string usrJSON en un objeto json para buscar la fecha
            System.out.println(jsonObject.getString("fechacosto"));
           
            Long mili=Long.parseLong(jsonObject.getString("fechacosto")) ; //convierto la fecha en Long
            Instant instant = Instant.ofEpochMilli(mili );
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("-03:00")); //Buenos Aires zona horaria - otro ej "UTC"
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedDateTime = localDateTime.format(formatter);
            System.out.println(formattedDateTime);
            //Hasta ACA la prueba de la fecha/hora - Tambien el JSON

            return usrJSON;
        } catch (Exception ex) {
            Logger.getLogger(sql.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "Ocurrio un error al crear json, la busqueda pudo haber arrojado null";
    }

/* -------------------------------------------------Actualiza datos --------------------------------------------------- */

    public static String actualizaProducto (
        Integer id,
        String producto,
        String codigo,
        String descripcion,
        Double costo,
        Timestamp fechacosto,
        Double precvta,
        Timestamp fechaprecvta,
        String proveedor,
        Integer ptoderepos
    ){
        if (id == 0){
            return "No se encontro Id";
        }
        Connection con;
        System.out.println("Actualizo registro - " + id);
        try {
            con = conectar();
            PreparedStatement ps = con.prepareStatement("UPDATE productos SET producto=?, codigo=?, descripcion=?, costo=?, fechcost=?, precvta=?, fechaprecvta=?, proveedor=?, ptoderepos=? WHERE id=?");
            
            ps.setString(1, producto);
            ps.setString(2, codigo);
            ps.setString(3, descripcion);
            ps.setDouble(4, costo);
            ps.setTimestamp(5, fechacosto);
            ps.setDouble(6, precvta);
            ps.setTimestamp(7, fechaprecvta);
            ps.setString(8, proveedor);
            ps.setInt(9, ptoderepos);
            ps.setInt(10, id);

            int res = ps.executeUpdate();

            //compruebaAdmin(id, admin, con);

            
            desconectar(con);

        } catch (SQLException e) {
            System.err.println(e);
            return "Ocurrio un error.";
        }



        return "Actualizacion correcta";
    }

    /* --------------------------------------------------Borra producto por Id------------------------------------------ */
    public static void borrarProducto (Integer id) {

        Connection con;
        ResultSet rs1 = null;

        try {
            con = conectar();

          

                System.out.println("3 - SQL Borra");
                PreparedStatement ps = con.prepareStatement("delete from productos where id = ?");
                ps.setInt(1, id);
                ps.executeUpdate();
           

            int res = ps.executeUpdate();


            desconectar(con);

        } catch (NumberFormatException | SQLException e) {
            System.err.println(e);
        }
    }


    /* --------------------------------------------Desde aca ingresos / Egresos------------------------------------------ */

    public static void agregarESStock(
    
    Integer id,
    Integer productosId,
    Timestamp fecha,
    Integer cantidad,
    Double costo,
    Double precvta,
    Integer sucursal,
    String ingegr,
    Integer cantoriginal,
    String proveedor
) {
    Connection con;
    System.out.println("Llego a SQL agregarESStock");

    try {
        con = conectar();
        PreparedStatement ps = con.prepareStatement("INSERT INTO ingegr ( productosid, fecha, cantidad, costo, precvta, sucursal, ingegr, cantoriginal, proveedor) VALUES(?,?,?,?,?,?,?,?,?) ",
        Statement.RETURN_GENERATED_KEYS);
        System.out.println("Fecha: " + fecha + " - Costo: "+ costo);
        // ps.setInt(1, id);
        ps.setInt(1, productosId);
        ps.setTimestamp(2, fecha);
        ps.setInt(3, cantidad);
        ps.setDouble(4, costo);
        ps.setDouble(5, precvta);
        ps.setInt(6, sucursal);
        ps.setString(7, ingegr);
        ps.setInt(8, cantoriginal);
        ps.setString(9, proveedor);

        int res = ps.executeUpdate();

        if (res > 0) { 
           /*  // Se obtiene el ID del usuario registrado
            ResultSet generatedKeys = ps.getGeneratedKeys();
            int usrid=-1;
            if (generatedKeys.next()) {
                usrid = generatedKeys.getInt(1);
            }

            if (admin) {
                PreparedStatement ps3 = con.prepareStatement("INSERT INTO administradores (usrid, esadmin) VALUES (?,?)");
                ps3.setInt(1, usrid);
                ps3.setBoolean(2, admin); // admin es el valor booleano

                ps3.executeUpdate();
            } */
        }
        desconectar(con);
    } catch (SQLException e) {
        System.err.println(e);
    }
}

public static void borrarESStock (Integer id){
    Connection con;

    try {
        con = conectar();
        PreparedStatement ps = con.prepareStatement("DELETE FROM ingegr WHERE id = ? ; ",
        Statement.RETURN_GENERATED_KEYS);
        System.out.println("Se borra id: " + id);
        // ps.setInt(1, id);
        ps.setInt(1, id);
        // ps.setTimestamp(2, fecha);
        // ps.setInt(3, cantidad);
        // ps.setDouble(4, costo);
        // ps.setDouble(5, precvta);
        // ps.setInt(6, sucursal);
        // ps.setString(7, ingegr);
        // ps.setInt(8, cantoriginal);
        // ps.setString(9, proveedor);

        int res = ps.executeUpdate();

        if (res > 0) { 
           /*  // Se obtiene el ID del usuario registrado
            ResultSet generatedKeys = ps.getGeneratedKeys();
            int usrid=-1;
            if (generatedKeys.next()) {
                usrid = generatedKeys.getInt(1);
            }

            if (admin) {
                PreparedStatement ps3 = con.prepareStatement("INSERT INTO administradores (usrid, esadmin) VALUES (?,?)");
                ps3.setInt(1, usrid);
                ps3.setBoolean(2, admin); // admin es el valor booleano

                ps3.executeUpdate();
            } */
        }
        desconectar(con);
    } catch (SQLException e) {
        System.err.println(e);
    }
}

public static String buscarESPorFecha(String fecha, Integer cant, String unidad) {
    Connection con;
    ResultSet rs = null;
    PreparedStatement ps = null;
    
    ObjectMapper mapper = new ObjectMapper();
    ArrayList<entradasalida> lista = new ArrayList<>();
    entradasalida es;

    try {
        con = conectar();
        if (unidad.equals("DAY")){
            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "" +
                    "WHERE fecha >= ? AND fecha <= (Select DATE_ADD(?, INTERVAL ? DAY)) " +
                    "ORDER BY id;");
            ps.setString(1, fecha);     // AAAA-MM-DD
            ps.setString(2, fecha);     // AAAA-MM-DD
            ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        }
        if (unidad.equals("MONTH")){
            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "" +
                    "WHERE fecha >= ? AND fecha <= (Select DATE_ADD(?, INTERVAL ? MONTH)) " +
                    "ORDER BY id;");
            ps.setString(1, fecha);     // AAAA-MM-DD
            ps.setString(2, fecha);     // AAAA-MM-DD
            ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        }
        if (unidad.equals("YEAR")){
            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "" +
                    "WHERE fecha >= ? AND fecha <= (Select DATE_ADD(?, INTERVAL ? YEAR)) " +
                    "ORDER BY id;");
            ps.setString(1, fecha);     // AAAA-MM-DD
            ps.setString(2, fecha);     // AAAA-MM-DD
            ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        }
        System.out.println("PreparedStatement: "+ps);


        rs = ps.executeQuery();

        

        // Leo uno a uno los registros traidos del la DB y los cargo en la lista
        while (rs.next()) {
            es = new entradasalida();
            es.setId(rs.getInt("id"));
            es.setProductosId(rs.getInt("productosid"));
            es.setFecha(rs.getTimestamp("fecha"));
            es.setCantidad(rs.getInt("cantidad"));
            es.setCosto(rs.getDouble("costo"));
            es.setPrecvta(rs.getDouble("precvta"));
            es.setSucursal(rs.getInt("sucursal"));
            es.setIngegr(rs.getString("ingegr"));
            es.setCantoriginal(rs.getInt("cantoriginal"));
            es.setProveedor(rs.getString("proveedor"));

            lista.add(es);
        }
        desconectar(con); //Desconecto de la DB

    } catch (SQLException e) {
        System.err.println(e);
    }
    
    if (lista.size() == 0){
        return "La busqueda arrojo cero resultados";
    };

    //Crea el json
    String usrJSON;
    try {
        usrJSON = mapper.writeValueAsString(lista);
        System.out.println(usrJSON);


        //Extra para probar el reformateo de fecha - Tambien se prueba convertir un String en JSON para poder buscar parametros por su nombre
        String usr1JSON = usrJSON;
        JSONObject jsonObject = new JSONObject(usr1JSON.replace("[", "").replace("]","")); //convierto el string usrJSON en un objeto json para buscar la fecha
        System.out.println(jsonObject.getString("fecha"));
       
        Long mili=Long.parseLong(jsonObject.getString("fecha")) ; //convierto la fecha en Long
        Instant instant = Instant.ofEpochMilli(mili );
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("-03:00")); //Buenos Aires zona horaria - otro ej "UTC"
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = localDateTime.format(formatter);
        System.out.println(formattedDateTime);
        //Hasta ACA la prueba de la fecha/hora - Tambien el JSON

        return usrJSON;
    } catch (Exception ex) {
        Logger.getLogger(sql.class.getName()).log(Level.SEVERE, null, ex);
    }
    return "Ocurrio un error al crear json, la busqueda pudo haber arrojado null";
}


public static String buscarESPoridcod(String tipo, String idcod) {
    Connection con;
    ResultSet rs = null;
    ResultSet rs1 = null;
    PreparedStatement ps = null;
    PreparedStatement ps1 = null;
    
    ObjectMapper mapper = new ObjectMapper();
    ArrayList<entradasalida> lista = new ArrayList<>();
    entradasalida es;

    try {
        con = conectar();
        if (tipo.equals("A")){
            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "" +
                    "" +
                    "ORDER BY id;");
            //ps.setInt(1, Integer.valueOf(idcod));     // AAAA-MM-DD
            //ps.setString(2, fecha);     // AAAA-MM-DD
            //ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        }
        if (tipo.equals("I")){
            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "" +
                    "WHERE id = ? " +
                    "ORDER BY id;");
            ps.setInt(1, Integer.valueOf(idcod));     // AAAA-MM-DD
            //ps.setString(2, fecha);     // AAAA-MM-DD
            //ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        }
        if (tipo.equals("C")){
            System.out.println("Entro en C");
            //Primero debo buscar el codigo en producto y el id obtenido lo aplico a la busqueda de ingegr
            ps1 = con.prepareStatement("SELECT id FROM productos WHERE codigo LIKE ?;");
            ps1.setString(1, "%"+idcod+"%");
            rs1 = ps1.executeQuery();
            rs1.next();
            System.out.println("Resultado del id para el codigo ingresado: "+rs1.getInt("id"));

            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "" +
                    "WHERE id = ? " +
                    "ORDER BY id;");
            ps.setInt(1, rs1.getInt("id"));     // AAAA-MM-DD
            //ps.setString(2, fecha);     // AAAA-MM-DD
            //ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        }
      
        //System.out.println("PreparedStatement: "+ps);


        rs = ps.executeQuery();

        

        // Leo uno a uno los registros traidos del la DB y los cargo en la lista
        while (rs.next()) {
            es = new entradasalida();
            es.setId(rs.getInt("id"));
            es.setProductosId(rs.getInt("productosid"));
            es.setFecha(rs.getTimestamp("fecha"));
            es.setCantidad(rs.getInt("cantidad"));
            es.setCosto(rs.getDouble("costo"));
            es.setPrecvta(rs.getDouble("precvta"));
            es.setSucursal(rs.getInt("sucursal"));
            es.setIngegr(rs.getString("ingegr"));
            es.setCantoriginal(rs.getInt("cantoriginal"));
            es.setProveedor(rs.getString("proveedor"));

            lista.add(es);
        }
        desconectar(con); //Desconecto de la DB

    } catch (SQLException e) {
        System.err.println(e);
    }
    
    if (lista.size() == 0){
        return "La busqueda arrojo cero resultados";
    };

    //Crea el json
    String usrJSON;
    try {
        usrJSON = mapper.writeValueAsString(lista);
        System.out.println(usrJSON);


        //Extra para probar el reformateo de fecha - Tambien se prueba convertir un String en JSON para poder buscar parametros por su nombre
        String usr1JSON = usrJSON;
        JSONObject jsonObject = new JSONObject(usr1JSON.replace("[", "").replace("]","")); //convierto el string usrJSON en un objeto json para buscar la fecha
        System.out.println(jsonObject.getString("fecha"));
       
        Long mili=Long.parseLong(jsonObject.getString("fecha")) ; //convierto la fecha en Long
        Instant instant = Instant.ofEpochMilli(mili );
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("-03:00")); //Buenos Aires zona horaria - otro ej "UTC"
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = localDateTime.format(formatter);
        System.out.println(formattedDateTime);
        //Hasta ACA la prueba de la fecha/hora - Tambien el JSON

        return usrJSON;
    } catch (Exception ex) {
        Logger.getLogger(sql.class.getName()).log(Level.SEVERE, null, ex);
    }
    return "Ocurrio un error al crear json, la busqueda pudo haber arrojado null";
}

public static String buscarESPoridcant(Integer id) {
    Connection con;
    ResultSet rs = null;
    PreparedStatement ps = null;
   
    ObjectMapper mapper = new ObjectMapper();
    ArrayList<entradasalida> lista = new ArrayList<>();
    entradasalida es;

    try {
        con = conectar();
        
            ps = con.prepareStatement("SELECT * " +
                    "FROM ingegr " +
                    "WHERE Productosid = ? AND cantidad > 0 AND Ingegr = 'I' "+
                    " " +
                    "ORDER BY id;");
            ps.setInt(1, Integer.valueOf(id));     // AAAA-MM-DD
            //ps.setString(2, fecha);     // AAAA-MM-DD
            //ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        
        //System.out.println("PreparedStatement: "+ps);


        rs = ps.executeQuery();

        

        // Leo uno a uno los registros traidos del la DB y los cargo en la lista
        while (rs.next()) {
            es = new entradasalida();
            es.setId(rs.getInt("id"));
            es.setProductosId(rs.getInt("productosid"));
            es.setFecha(rs.getTimestamp("fecha"));
            es.setCantidad(rs.getInt("cantidad"));
            es.setCosto(rs.getDouble("costo"));
            es.setPrecvta(rs.getDouble("precvta"));
            es.setSucursal(rs.getInt("sucursal"));
            es.setIngegr(rs.getString("ingegr"));
            es.setCantoriginal(rs.getInt("cantoriginal"));
            es.setProveedor(rs.getString("proveedor"));

            lista.add(es);
        }
        desconectar(con); //Desconecto de la DB

    } catch (SQLException e) {
        System.err.println(e);
    }
    
    if (lista.size() == 0){
        return "La busqueda arrojo cero resultados";
    };

    //Crea el json
    String usrJSON;
    try {
        usrJSON = mapper.writeValueAsString(lista);
        System.out.println(usrJSON);


        //Extra para probar el reformateo de fecha - Tambien se prueba convertir un String en JSON para poder buscar parametros por su nombre
        String usr1JSON = usrJSON;
        JSONObject jsonObject = new JSONObject(usr1JSON.replace("[", "").replace("]","")); //convierto el string usrJSON en un objeto json para buscar la fecha
        System.out.println(jsonObject.getString("fecha"));
       
        Long mili=Long.parseLong(jsonObject.getString("fecha")) ; //convierto la fecha en Long
        Instant instant = Instant.ofEpochMilli(mili );
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("-03:00")); //Buenos Aires zona horaria - otro ej "UTC"
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = localDateTime.format(formatter);
        System.out.println(formattedDateTime);
        //Hasta ACA la prueba de la fecha/hora - Tambien el JSON

        return usrJSON;
    } catch (Exception ex) {
        Logger.getLogger(sql.class.getName()).log(Level.SEVERE, null, ex);
    }
    return "Ocurrio un error al crear json, la busqueda pudo haber arrojado null";


}

public static void actualizaEScant(Integer id, Integer cant) {
    Connection con;
    // ResultSet rs = null;
    PreparedStatement ps = null;
   
    ObjectMapper mapper = new ObjectMapper();
    ArrayList<entradasalida> lista = new ArrayList<>();
    entradasalida es;

    try {
        con = conectar();
        
            ps = con.prepareStatement("UPDATE ingegr " +
                    "SET cantidad = ? WHERE id = ? ;" 
                    );
            ps.setInt(1, Integer.valueOf(cant));     // AAAA-MM-DD
            ps.setInt(2, id);     // AAAA-MM-DD
            //ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        
        //System.out.println("PreparedStatement: "+ps);


        int rs = ps.executeUpdate();

        

        // Leo uno a uno los registros traidos del la DB y los cargo en la lista
        // while (rs.next()) {
        //     es = new entradasalida();
        //     es.setId(rs.getInt("id"));
        //     es.setProductosId(rs.getInt("productosid"));
        //     es.setFecha(rs.getTimestamp("fecha"));
        //     es.setCantidad(rs.getInt("cantidad"));
        //     es.setCosto(rs.getDouble("costo"));
        //     es.setPrecvta(rs.getDouble("precvta"));
        //     es.setSucursal(rs.getInt("sucursal"));
        //     es.setIngegr(rs.getString("ingegr"));
        //     es.setCantoriginal(rs.getInt("cantoriginal"));
        //     es.setProveedor(rs.getString("proveedor"));

        //     lista.add(es);
        // }
        desconectar(con); //Desconecto de la DB

    } catch (SQLException e) {
        System.err.println(e);
    }

};


/* -----------------------------------------------------Desde aca informes--------------------------------------------- */
public static String informes(String fechaini, String fechafin) {
    Connection con;
    ResultSet rs = null;
    PreparedStatement ps = null;
   
    ObjectMapper mapper = new ObjectMapper();
    ArrayList<entradasalida> lista = new ArrayList<>();
    entradasalida es;

    try {
        con = conectar();
        
            // ps = con.prepareStatement("SELECT * " +
            //         "FROM ingegr "+
            //         "WHERE fecha > ? AND fecha < ? ;" 
            //         );
            ps = con.prepareStatement("SELECT ingegr.Id, ingegr.ProductosId,ingegr.Fecha,ingegr.Cantidad,ingegr.Costo,ingegr.PrecVta,ingegr.Sucursal,ingegr.IngEgr,ingegr.CantOriginal,ingegr.Proveedor, productos.Producto " +
                    "FROM ingegr "+
                    "INNER JOIN productos ON Productos.id = ingegr.ProductosId "+
                    "WHERE ingegr.fecha >= '" + fechaini + "' AND ingegr.fecha < '" + fechafin + "'" 
                    );
            // ps.setString(1, fechaini);     // AAAA-MM-DD
            // ps.setString(2, fechafin);     // AAAA-MM-DD
            //ps.setInt(3, cant);         // cantidad de dias, meses o anos a incluir en la busqueda
            // ps.setString(4, unidad);    // DAY MONTH YEAR - es la unidad en la que esta el int anterior para sumar a la fecha
        
        //System.out.println("PreparedStatement: "+ps);


        rs = ps.executeQuery();

       // Leo uno a uno los registros traidos del la DB y los cargo en la lista
       while (rs.next()) {
        es = new entradasalida();
        es.setId(rs.getInt("id"));
        es.setProductosId(rs.getInt("productosid"));
        es.setFecha(rs.getTimestamp("fecha"));
        es.setCantidad(rs.getInt("cantidad"));
        es.setCosto(rs.getDouble("costo"));
        es.setPrecvta(rs.getDouble("precvta"));
        es.setSucursal(rs.getInt("sucursal"));
        es.setIngegr(rs.getString("ingegr"));
        es.setCantoriginal(rs.getInt("cantoriginal"));
        es.setProveedor(rs.getString("proveedor"));
        es.setProducto(rs.getString("producto"));

        lista.add(es);
    }
    desconectar(con); //Desconecto de la DB

    } catch (SQLException e) {
        System.err.println(e);
    }

    if (lista.size() == 0){
        return "La busqueda arrojo cero resultados";
    };

    //Crea el json
    String usrJSON;
    try {
        usrJSON = mapper.writeValueAsString(lista);
        System.out.println(usrJSON);


        //Extra para probar el reformateo de fecha - Tambien se prueba convertir un String en JSON para poder buscar parametros por su nombre
        String usr1JSON = usrJSON;
        JSONObject jsonObject = new JSONObject(usr1JSON.replace("[", "").replace("]","")); //convierto el string usrJSON en un objeto json para buscar la fecha
        System.out.println(jsonObject.getString("fecha"));
    
        Long mili=Long.parseLong(jsonObject.getString("fecha")) ; //convierto la fecha en Long
        Instant instant = Instant.ofEpochMilli(mili );
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("-03:00")); //Buenos Aires zona horaria - otro ej "UTC"
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = localDateTime.format(formatter);
        System.out.println(formattedDateTime);
        //Hasta ACA la prueba de la fecha/hora - Tambien el JSON

        return usrJSON;
    } catch (Exception ex) {
        Logger.getLogger(sql.class.getName()).log(Level.SEVERE, null, ex);
    }
    return "Ocurrio un error al crear json, la busqueda pudo haber arrojado null"; 


    };

}
